let objects = require('common/objects');
let templates = require('common/templates');

let CLASS_NAMES = {
  mailobject: 'E-Mails',
  maildocumentobject: 'E-Mail-Anhänge/Dokumente',
  previewimage: 'Previews',
  fileobject: 'Dokumente',
  documenttextobject: 'Documententext-Objekte (für Suche)',
  attributexmlobject: 'Metadaten-Objekte'
};

let format = number => {
  return templates.fill('${num:de|#,###.##}', { num: number });
};

let result = objects.query('*').includeHidden(true).limit(0).facets({
  types: {
    type: 'terms',
    field: 'classname_cs',
    facet: {
      sum_size: 'sum(contentsize)',
    },
    sort: {
      sum_size: 'desc'
    },
    limit: 10
  }
}).search().facets;

let output = [];
let others = {
  size: 0,
  label: 'Andere',
  amount: 0
};

let sum = {
  size: 0,
  label: '-----------------------------------------------------------------------------------------------\nSumme',
  amount: 0
};

result.types.buckets.forEach(bucket => {
  let label = CLASS_NAMES[bucket.val.toLowerCase()];
  
  sum.size += bucket.sum_size;
  sum.amount += bucket.count;
  
  if (!label) {
    others.amount += bucket.count;
    others.size += bucket.sum_size;
    return;
  }
  
  output.push({
    label: label,
    size: bucket.sum_size,
    amount: bucket.count
  });
});

output.push(others);

let sumDeleted = {
  size: 0,
  label: '-----------------------------------------------------------------------------------------------\nDavon im Serverpapierkorb',
  amount: 0
};


let resultTrash = objects.query('allfields:deletedate').includeHidden(true).limit(0).facets({
  types: {
    type: 'terms',
    field: 'classname_cs',
    facet: {
      sum_size: 'sum(contentsize)',
    },
    sort: {
      sum_size: 'desc'
    },
    limit: 10
  }
}).search().facets;

resultTrash.types.buckets.forEach(bucket => {
  sumDeleted.size += bucket.sum_size;
  sumDeleted.amount += bucket.count;
});

output.push(sum);
output.push(sumDeleted);

output.map(o => {
  return o.label + ': ' + format(o.size/1000/1000) + ' MB, Anzahl: ' + format(o.amount);
}).join('\n');
